<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-6 text-start">
                            <h5 style="color:#393185">Users table</h5>
                        </div>
                        <div class="col-md-6 text-end">
                            <a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary btn-sm">Add New User</a>
                        </div>
                    </div>


                </div>
                <div class="card-body px-0 pt-0 pb-2">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                    <?php endif; ?>

                    <!-- Search Form -->
                    <div class="row mb-3">

                        <div class="col-md-7 offset-md-5" style="">
                            <form method="GET" action="<?php echo e(route('users.index')); ?>">
                                <div class="input-group" style="padding-right:25px;">
                                    <input type="text" class="form-control" name="search" placeholder="search"
                                        value="<?php echo e(request('search') ?: 'search'); ?>">

                                    <button class="btn btn-outline-primary" type="submit">Search</button>

                                    

                                    <button class="btn btn-outline-secondary" type="button"
                                        onclick="location.href='<?php echo e(route('users.index')); ?>'">Clear</button>
                                </div>
                            </form>


                        </div>

                    </div>
                    <div class="table-responsive p-0">
                        <table class="table align-items-center mb-0">
                            <thead>
                                <tr>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Name
                                    </th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                        Company Name</th>
                                    
                                    <th
                                        class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Mobile NO.</th>
                                    <th
                                        class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        City</th>
                                    <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Pay Status</th>
                                    <th
                                        class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        QR Image</th>
                                    <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex px-2 py-1">
                                                <div class="d-flex flex-column justify-content-center">
                                                    <h6 class="mb-0 text-sm"><?php echo e($user->name); ?></h6>
                                                    <p class="text-xs text-secondary mb-0"><?php echo e($user->email); ?></p>
                                                    <p class="text-xs text-secondary mb-0">Occupation:<?php echo e($user->occupation ?? 'N/A'); ?></p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <p class="text-xs font-weight-bold mb-0"><?php echo e($user->comp_name ?? 'N/A'); ?></p>
                                        </td>
                                        
                                        <td class="align-middle text-center">
                                            <span
                                                class="text-secondary text-xs font-weight-bold"><?php echo e($user->phone ?? 'N/A'); ?></span>
                                        </td>
                                        <td class="align-middle text-center">
                                            <span
                                                class="text-secondary text-xs font-weight-bold"><?php echo e($user->city ?? 'N/A'); ?></span>
                                        </td>
                                        
                                         <td class="align-middle text-center">
                                            <span
                                                class="text-secondary text-xs font-weight-bold"><?php echo e($user->payment_status ?? 'N/A'); ?></span>
                                        </td>

                                        <td class="align-middle text-center">
                                            <span class="text-secondary text-xs font-weight-bold">
                                                <img src="<?php echo e(asset('users_qr_images/' . $user->qr_image)); ?>" alt="QR Code"
                                                    style="width:40px; cursor:pointer;" data-bs-toggle="modal"
                                                    data-bs-target="#qrModal"
                                                    data-bs-image="<?php echo e(asset('users_qr_images/' . $user->qr_image)); ?>"
                                                    data-bs-name="<?php echo e($user->name); ?>">
                                            </span>
                                        </td>
                                       

                                        <td class="align-middle">
                                            

                                            
                                            <a href="<?php echo e(route('download.idcard', $user->id)); ?>"
                                                class="text-secondary font-weight-bold text-xs" data-toggle="tooltip"
                                                data-original-title="Download ID Card">
                                                <span class="badge badge-sm bg-gradient-success">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                        fill="currentColor" class="bi bi-file-earmark-arrow-down-fill"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0M9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1m-1 4v3.793l1.146-1.147a.5.5 0 0 1 .708.708l-2 2a.5.5 0 0 1-.708 0l-2-2a.5.5 0 0 1 .708-.708L7.5 11.293V7.5a.5.5 0 0 1 1 0" />
                                                    </svg>
                                                    ID Card
                                                </span>
                                            </a>



                                            <a href="<?php echo e(route('users.print', $user->id)); ?>"
                                                class="text-secondary font-weight-bold text-xs">
                                                <span class="badge badge-sm bg-gradient-success">Print</span>
                                            </a>

                                            <a href="<?php echo e(route('users.edit', $user->id)); ?>"
                                                class="text-secondary font-weight-bold text-xs" data-toggle="tooltip"
                                                data-original-title="Edit user">
                                                <span class="badge badge-sm bg-gradient-success">Edit</span>


                                            </a>

                                            <form action="<?php echo e(route('users.destroy', $user->id)); ?>" method="POST"
                                                style="display: inline;"
                                                onsubmit="return confirm('Are you sure you want to delete this user?')">
                                                <?php echo csrf_field(); ?>

                                                <button type="submit"
                                                    class="text-danger font-weight-bold text-xs border-0 bg-transparent"
                                                    style="cursor: pointer;">
                                                    <span class="badge badge-sm bg-gradient-danger">Delete</span>

                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="text-center">No users found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <!-- Pagination -->
                        <div class="d-flex justify-content-end mt-3">
                            
                            <?php echo e($users->links('vendor.pagination.bootstrap-4')); ?>


                        </div>

                        
                        <div class="modal fade" id="qrModal" tabindex="-1" aria-labelledby="qrModalLabel"
                            aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="qrModalLabel">QR Code</h5>
                                        <!-- Close button -->
                                        
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close" style="filter: invert(1);"></button>

                                    </div>
                                    <div class="modal-body text-center">
                                        <h5 id="modalUserName" class="mb-3" style="color:darkblue;"></h5>
                                        <img id="modalQrImage" src="" alt="QR Code"
                                            style="max-width:100%; height:auto;">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var qrModal = document.getElementById('qrModal');
            qrModal.addEventListener('show.bs.modal', function(event) {
                var button = event.relatedTarget;
                var imageSrc = button.getAttribute('data-bs-image');
                var userName = button.getAttribute('data-bs-name');

                var modalImage = qrModal.querySelector('#modalQrImage');
                var modalName = qrModal.querySelector('#modalUserName');

                modalImage.src = imageSrc;
                modalName.textContent = userName;
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/techmetworks/public_html/aimaindex.techmetworks.com/resources/views/admin/user/index.blade.php ENDPATH**/ ?>