@extends('admin.layout.master')
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-6 text-start">
                            <h5 style="color:#393185">Users table</h5>
                        </div>
                        <div class="col-md-6 text-end">
                            <a href="{{ route('users.create') }}" class="btn btn-primary btn-sm">Add New User</a>
                        </div>
                    </div>


                </div>
                <div class="card-body px-0 pt-0 pb-2">
                    @if (session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif

                    <!-- Search Form -->
                    <div class="row mb-3">
                        {{--  <div class="col-md-6 offset-md-6" style="padding-right:20px;">
                            <form method="GET" action="{{ route('users.index') }}">
                                <div class="input-group">
                                    <input type="text" class="form-control" name="search" placeholder="Search by name or email..." value="{{ request('search') }}" style="height:43px;">
                                    <button class="btn btn-outline-primary" type="submit">Search</button>
                                </div>
                            </form>
                        </div>  --}}
                        <div class="col-md-7 offset-md-5" style="">
                            <form method="GET" action="{{ route('users.index') }}">
                                <div class="input-group" style="padding-right:25px;">
                                    <input type="text" class="form-control" name="search" placeholder="search"
                                        value="{{ request('search') ?: 'search' }}">

                                    <button class="btn btn-outline-primary" type="submit">Search</button>

                                    {{--  <button class="btn btn-outline-secondary" type="button"
                                        onclick="this.previousElementSibling.value=''">Clear Field</button>  --}}

                                    <button class="btn btn-outline-secondary" type="button"
                                        onclick="location.href='{{ route('users.index') }}'">Clear</button>
                                </div>
                            </form>


                        </div>

                    </div>
                    <div class="table-responsive p-0">
                        <table class="table align-items-center mb-0">
                            <thead>
                                <tr>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Name
                                    </th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                        Company Name</th>
                                    <th
                                        class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Occupation</th>
                                    <th
                                        class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Mobile Number</th>
                                    <th
                                        class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        City</th>
                                    <th
                                        class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        QR Image</th>
                                    <th class="text-secondary opacity-7">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($users as $user)
                                    <tr>
                                        <td>
                                            <div class="d-flex px-2 py-1">
                                                <div class="d-flex flex-column justify-content-center">
                                                    <h6 class="mb-0 text-sm">{{ $user->name }}</h6>
                                                    <p class="text-xs text-secondary mb-0">{{ $user->email }}</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <p class="text-xs font-weight-bold mb-0">{{ $user->comp_name ?? 'N/A' }}</p>
                                        </td>
                                        <td class="align-middle text-center text-sm">
                                            {{ $user->occupation ?? 'N/A' }}
                                        </td>
                                        <td class="align-middle text-center">
                                            <span
                                                class="text-secondary text-xs font-weight-bold">{{ $user->phone ?? 'N/A' }}</span>
                                        </td>
                                        <td class="align-middle text-center">
                                            <span
                                                class="text-secondary text-xs font-weight-bold">{{ $user->city ?? 'N/A' }}</span>
                                        </td>
                                        <td class="align-middle text-center">
                                            <span class="text-secondary text-xs font-weight-bold">
                                                <img src="{{ asset('users_qr_images/' . $user->qr_image) }}" alt=""
                                                    style="width:40px;">
                                                {{--  <br>{{ $user->qr_code ?? 'N/A' }}  --}}
                                            </span>
                                        </td>
                                        <td class="align-middle">
                                            <a href="{{ route('user.id-card', $user->id) }}"
                                                class="text-secondary font-weight-bold text-xs" data-toggle="tooltip"
                                                data-original-title="Download ID Card">
                                                <span class="badge badge-sm bg-gradient-success"><svg
                                                        xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                        fill="currentColor" class="bi bi-file-earmark-arrow-down-fill"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0M9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1m-1 4v3.793l1.146-1.147a.5.5 0 0 1 .708.708l-2 2a.5.5 0 0 1-.708 0l-2-2a.5.5 0 0 1 .708-.708L7.5 11.293V7.5a.5.5 0 0 1 1 0" />
                                                    </svg>Id_Card</span>

                                            </a>
                                            <a href="{{ route('users.edit', $user->id) }}"
                                                class="text-secondary font-weight-bold text-xs" data-toggle="tooltip"
                                                data-original-title="Edit user">
                                                <span class="badge badge-sm bg-gradient-success">Edit</span>

                                            </a>
                                            <form action="{{ route('users.destroy', $user->id) }}" method="POST"
                                                style="display: inline;"
                                                onsubmit="return confirm('Are you sure you want to delete this user?')">
                                                @csrf

                                                <button type="submit"
                                                    class="text-danger font-weight-bold text-xs border-0 bg-transparent"
                                                    style="cursor: pointer;">
                                                    <span class="badge badge-sm bg-gradient-danger">Delete</span>

                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">No users found.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        <!-- Pagination -->
                        <div class="d-flex justify-content-end mt-3">
                            {{--  {{ $users->links() }}  --}}
                            {{ $users->links('vendor.pagination.bootstrap-4') }}

                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
